async function load() {
  const stored = await chrome.storage.local.get(['gatewayUrl', 'gatewayToken'])
  document.getElementById('gatewayUrl').value = stored.gatewayUrl || ''
  document.getElementById('gatewayToken').value = stored.gatewayToken || ''
}

async function save() {
  const url = document.getElementById('gatewayUrl').value.trim()
  const token = document.getElementById('gatewayToken').value.trim()
  await chrome.storage.local.set({ gatewayUrl: url, gatewayToken: token })
  
  const status = document.getElementById('status')
  status.textContent = 'Configuration saved. Reloading Alfred...'
  status.style.color = '#10b981'
  
  setTimeout(() => { status.textContent = '' }, 2000)
}

document.getElementById('save').addEventListener('click', save)
load()
